#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_set>

using namespace std;

int main() {
    int n, k;
    cin >> n >> k;

    vector<int> x(k);
    for (int& xi : x) {
        cin >> xi;
    }

    vector<int> p(n);
    for (int& pi : p) {
        cin >> pi;
    }

    unordered_set<int> existingStores;
    for (int i = 0; i < k; ++i) {
        existingStores.insert(x[i]);
    }

    long long totalCustomers = 0;
    for (int customer : p) {
        totalCustomers += customer;
    }

    long long customersInExistingStores = 0;
    for (int storeLocation : x) {
        customersInExistingStores += p[storeLocation - 1]; 
    }

    vector<pair<int, int>> cityCustomers;
    for (int i = 0; i < n; ++i) {
        if (existingStores.find(i + 1) == existingStores.end()) {
            cityCustomers.push_back({p[i], i + 1});
        }
    }

    sort(cityCustomers.rbegin(), cityCustomers.rend());

    long long requiredCustomers = totalCustomers / 2 + 1;
    long long accumulatedCustomers = customersInExistingStores;
    int storesNeeded = 0;

    if (accumulatedCustomers < requiredCustomers) {
        for (const auto &city : cityCustomers) {
            if (accumulatedCustomers < requiredCustomers) {
                accumulatedCustomers += city.first;
                storesNeeded++;
            }
        }
    }

    cout << storesNeeded << endl;

    return 0;
}